% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq5d_aux.R
\name{.prep_fu}
\alias{.prep_fu}
\title{Data checking/preparation: follow-up variable}
\usage{
.prep_fu(df, name = NULL, levels = NULL)
}
\arguments{
\item{df}{A data frame.}

\item{name}{Column name in the data frame that contains follow-up information.}

\item{levels}{Levels to factorise the FU variable into.}
}
\value{
A data frame with the follow-up variable renamed as "fu" and factorised.
}
\description{
This function prepares the follow-up (FU) variable for analysis by giving it a default name (`fu`) and factorising
}
\examples{
df <- data.frame(id = c(1, 1, 2, 2),
  visit = c("baseline", "follow-up", "baseline", "follow-up"))
.prep_fu(df = df, name = "visit", levels = c("baseline", "follow-up"))
}
