% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq5d_aux.R
\name{.prep_vas}
\alias{.prep_vas}
\title{Data checking/preparation: VAS variable}
\usage{
.prep_vas(df, name)
}
\arguments{
\item{df}{A data frame.}

\item{name}{Column name in the data frame that holds the VAS score. The column can only contain integers or NAs}
}
\value{
A modified data frame with the VAS score renamed to "vas". If any checks fail (e.g. column is not numeric), an error message is displayed and the function is stopping.
}
\description{
The function prepares the data for VAS (Visual Analogue Scale) analyses.
}
\examples{
df <- data.frame(vas_score = c(20, 50, 80, NA, 100))
.prep_vas(df = df, name = "vas_score")
df <- data.frame(vas_score = c(20.5, 50, 80, NA, 100))
.prep_vas(df = df, name = "vas_score")
}
