% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equivTest_MWCMLE.R
\name{RMLE_equivTest}
\alias{RMLE_equivTest}
\title{Perform restricted MLE  (RMLE) to estimate parameters under the constraint defined by the boundary of null hypothesis}
\usage{
RMLE_equivTest(nT, nR, smplMuT, smplMuR, smplSigmaT, smplSigmaR, vecT,
  vecR, eta)
}
\arguments{
\item{nT}{sample size for test data}

\item{nR}{sample size for reference data}

\item{smplMuT}{sample mean for test data}

\item{smplMuR}{sample mean for reference data}

\item{smplSigmaT}{sample standard deviation for test data}

\item{smplSigmaR}{sample standard devivation for reference data}

\item{vecT}{a vector of observations for test product}

\item{vecR}{a vector of observations for reference product}

\item{eta}{the margin multipler}
}
\value{
a list containing the RMLE for the means and standard deviations for both test and reference data
}
\description{
Perform restricted MLE  (RMLE) to estimate parameters under the constraint defined by the boundary of null hypothesis, \eqn{\mu_T - \mu_R = \eta\sigma_R} where \eqn{\eta} is the margin multiplier.
}
