% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{equivTestPlot}
\alias{equivTestPlot}
\title{Plot the equivalence test result}
\usage{
equivTestPlot(meanDif, ci, alpha, margin, qaNameLong, testDrugName = "",
  refDrugName = "", showDrugName = FALSE, showQA = FALSE,
  showCINumbers = FALSE)
}
\arguments{
\item{meanDif}{difference between mean of test and reference product}

\item{ci}{confidence interval for mean difference, a vector of two values}

\item{alpha}{nominal level of the hypothesis test}

\item{margin}{a vector consisting of lower margin and upper margin}

\item{qaNameLong}{the quality attribute name}

\item{testDrugName}{test drug name}

\item{refDrugName}{reference drug name}

\item{showDrugName}{logic value indicating if the drug names are to be shown.}

\item{showQA}{logic value indicating if the quality attribute (QA) is to be shown.}

\item{showCINumbers}{whether CI values are shown in the figure.}
}
\description{
Plot the equivalence test result including the margin, confidence intervals of the mean difference, and estimated mean difference.
}
\examples{
equivTestPlot(0.623,c(-2,2),0.05,c(-9.79,9.79),
  "q a","test","reference")
equivTestPlot(0.623,c(-2,2),0.05,c(-9.79,9.79),
  "Relative Potency","test","reference",showDrugName = TRUE,showQA=TRUE,showCINumbers = TRUE)
equivTestPlot(0.5,c(-1.05,2.05),0.05,c(-9.79,9.79),
  "Relative Potency","test","reference",showQA=TRUE,showCINumbers = TRUE)
}
