% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.sign.R
\name{dsf-ergmTerm}
\alias{dsf-ergmTerm}
\alias{InitErgmTerm.dsf}
\title{Dyadwise shared friends}
\usage{
# binary: dsf(d, type="OTP", in_order=FALSE)
}
\description{
This term adds one network statistic to the model for each element in `d` where the \eqn{i} th such statistic equals the number of dyads in the network with exactly `d[i]` shared friends. For a directed network, multiple shared friends definitions are possible.
}
\note{
This term takes an additional term option (see
  [`options?ergm`][ergm-options]), `cache.sp`, controlling whether
  the implementation will cache the number of shared partners for
  each dyad in the network; this is usually enabled by default.
}
\section{Shared partner types}{
 While there is only one shared partner configuration in the undirected
  case, nine distinct configurations are possible for directed graphs, selected
  using the `type` argument. Currently, terms may be defined with respect to
  five of these configurations; they are defined here as follows (using
  terminology from Butts (2008) and the `relevent` package):
-  Outgoing Two-path (`"OTP"`): vertex \eqn{k} is an OTP shared partner of ordered
   pair \eqn{(i,j)} iff \eqn{i \to k \to j}{i->k->j}. Also known as "transitive
   shared partner".
- Incoming Two-path (`"ITP"`): vertex \eqn{k} is an ITP shared partner of ordered
   pair \eqn{(i,j)} iff \eqn{j \to k \to i}{j->k->i}. Also known as "cyclical shared
   partner"
- Reciprocated Two-path (`"RTP"`): vertex \eqn{k} is an RTP shared partner of ordered
   pair \eqn{(i,j)} iff \eqn{i \leftrightarrow k \leftrightarrow j}{i<->k<->j}.
- Outgoing Shared Partner (`"OSP"`): vertex \eqn{k} is an OSP shared partner of
   ordered pair \eqn{(i,j)} iff \eqn{i \to k, j \to k}{i->k, j->k}.
- Incoming Shared Partner (`"ISP"`): vertex \eqn{k} is an ISP shared partner of ordered
   pair \eqn{(i,j)} iff \eqn{k \to i, k \to j}{k->i, k->j}.
By default, outgoing two-paths (`"OTP"`) are calculated. Note that Robins et al. (2009)
  define closely related statistics to several of the above, using slightly different terminology.
}

\seealso{
[`ergmTerm`] for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "dsf", "subsection")}
}
\concept{directed}
\concept{undirected}
