% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-type.R
\name{check_type}
\alias{check_type}
\title{Check Argument's Type}
\usage{
check_type(
  x,
  valid,
  name = NULL,
  general = NULL,
  specific = NULL,
  supplement = NULL,
  ...
)
}
\arguments{
\item{x}{The argument to check, which can be any object.}

\item{valid}{A character vector which contains the valid types.}

\item{name}{A single character which gives the argument's name.
The name is used in the error message. By default, the name of the
argument passed to argument \code{x} is captured automatically.}

\item{general}{Optional. A single character which is used to give a
general statement of the error incurred. By default, this is generated
automatically.}

\item{specific}{Optional. A single character which gives a detailed
description of the error. \code{\link[glue:glue]{glue::glue()}} syntax can be used, see
"Examples" section. By default, this is generated automatically.}

\item{supplement}{Optional. A (named) character vector which gives some
additional information about the error. The names are used to create
bullets, see \code{\link[=throw]{throw()}}. By default, this is left empty.}

\item{...}{Optional. Additional arguments which can be retrieved with
\code{\link[=tryCatch]{tryCatch()}}.}
}
\value{
returns an invisible \code{NULL} if the argument is valid, or
generates an error message.
}
\description{
Check if an argument has valid type,
and if not, generate an error message.
}
\examples{
# argument to check
arg <- 10

# returns silently if the argument has valid type
check_type(arg, "double")

\dontrun{
check_type(arg, "character")

# specify argument's name
check_type(arg, "character", name = "x")

# specify argument `specific` with `glue::glue()` syntax
specific <- "`{name}`'s type is {feature}, which is wrong."
check_type(arg, "character", specific = specific)

# specify argument `supplement`
supplement <- c("You're wrong.", i = "Check your code.")
check_type(arg, "character", supplement = supplement)

# turn off `specific`
check_type(arg, "character", specific = character())
}

# add and retrieve additional argument
tryCatch(
  {check_type(arg, "character", your_arg = "your data")},
  error = function(e) e$your_arg
)
}
\seealso{
\code{vignette("erify")} for a gentle introduction to this package.
}
