% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backtest_functions.R
\name{cc_backtest}
\alias{cc_backtest}
\title{Conditional Calibration Backtest}
\usage{
cc_backtest(r, q, e, s = NULL, alpha, hommel = TRUE)
}
\arguments{
\item{r}{A vector of returns.}

\item{q}{A vector of Value-at-Risk forecasts.}

\item{e}{A vector of Expected Shortfall forecasts.}

\item{s}{A vector of volatility forecasts.}

\item{alpha}{Scalar probability level in (0, 1).}

\item{hommel}{If TRUE, use Hommels correction,
otherwise use the classical Bonferroni correction.}
}
\value{
Returns a list with the following components:
\itemize{
\item pvalue_twosided_simple
\item pvalue_onesided_simple
\item pvalue_twosided_general
\item pvalue_onesided_general
}
}
\description{
The simple and general conditional calibration backtests of Nolde & Ziegel (2007).
}
\examples{
data(risk_forecasts)
r <- risk_forecasts$r
q <- risk_forecasts$q
e <- risk_forecasts$e
s <- risk_forecasts$s
cc_backtest(r = r, q = q, e = e, s = s, alpha = 0.025)
}
\references{
Nolde & Ziegel (2007) \doi{10.1214/17-AOAS1041}
}
