% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/escalation-package.R
\docType{package}
\name{escalation-package}
\alias{escalation-package}
\alias{escalation}
\title{The 'escalation' package.}
\description{
escalation provides methods for working with dose-finding clinical trials.
We provide implementations of many dose-finding clinical trial designs,
ncluding the continual reassessment method (CRM) by O'Quigley et al. (1990)
<doi:10.2307/2531628>, the toxicity probability interval (TPI) design by Ji
et al. (2007) <doi:10.1177/1740774507079442>, the modified TPI (mTPI) design
by Ji et al. (2010) <doi:10.1177/1740774510382799>, the Bayesian optimal
interval design (BOIN) by Liu & Yuan (2015) <doi:10.1111/rssc.12089>, EffTox
by Thall & Cook (2004) <doi:10.1111/j.0006-341X.2004.00218.x>; the design of
Wages & Tait (2015) <doi:10.1080/10543406.2014.920873>, and the 3+3
described by Korn et al. (1994) <doi:10.1002/sim.4780131802>. All designs
are implemented with a common interface. We also offer optional additional
classes to tailor the behaviour of all designs, including avoiding skipping
doses, stopping after n patients have been treated at the recommended dose,
stopping when a toxicity condition is met, or demanding that n patients are
treated before stopping is allowed. By daisy-chaining together these classes
using the pipe operator from 'magrittr', it is simple to tailor the
behaviour of a dose-finding design so it behaves how the trialist wants.
Having provided a flexible interface for specifying designs, we then provide
functions to run simulations and calculate dose-paths for future cohorts of
patients.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://brockk.github.io/escalation/}
  \item \url{https://github.com/brockk/escalation}
  \item Report bugs at \url{https://github.com/brockk/escalation/issues}
}

}
\author{
\strong{Maintainer}: Kristian Brock \email{kristian.brock@gmail.com} (\href{https://orcid.org/0000-0002-3921-0166}{ORCID})

Authors:
\itemize{
  \item Daniel Slade (\href{https://orcid.org/0000-0001-6063-1283}{ORCID})
  \item Michael Sweeting (\href{https://orcid.org/0000-0003-0980-8965}{ORCID})
}

Other contributors:
\itemize{
  \item Conor Norris (\href{https://orcid.org/0009-0009-8850-0811}{ORCID}) [contributor]
  \item Bharat Bhushan (\href{https://orcid.org/0009-0001-5271-7113}{ORCID}) [contributor]
}

}
\keyword{internal}
