% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_lasso.R, R/functions_ridge.R
\name{festLASSO}
\alias{festLASSO}
\alias{festRidge}
\title{Compute `Future Loss' Ridge or LASSO Estimates}
\usage{
festLASSO(
  X,
  y,
  loss = c("fMSE", "fMBV", "both"),
  ind = 1,
  lseq,
  B = 500,
  penalize,
  rescale.lambda = TRUE,
  scale = FALSE,
  returnMSE = FALSE,
  postsamp,
  returnPS = FALSE,
  nPost = 1000,
  se.version = c("varExp", "full", "none"),
  ...
)

festRidge(
  X,
  y,
  loss = c("fMSE", "fMBV", "both"),
  ind = 1,
  lseq,
  penalize,
  scale = FALSE,
  returnMSE = FALSE,
  postsamp,
  returnPS = FALSE,
  nPost = 1000,
  se.version = c("varExp", "full", "none"),
  XtXlamIinv = NULL,
  ...
)
}
\arguments{
\item{X}{Design matrix for the regression. Assumed to contain only numeric values, so 
any factors should be coded according to desired contrast (e.g., via \code{\link{model.matrix}})}

\item{y}{Outcome vector. Unless \code{X} contains an intercept column, this should typically be centered.}

\item{loss}{Loss function for choosing the penalty parameter. See details.}

\item{ind}{Vector of integers or logicals indicating which coefficients the loss is to be computed on.}

\item{lseq}{Sequence of penalty values to consider.}

\item{B}{Number of future datasets to simulate for each point in posterior sample.}

\item{penalize}{See \code{\link{estRidge}}}

\item{rescale.lambda}{If \code{TRUE}, then lambda is rescaled to account for the 
default re-scaling done by \code{glmnet}. Can also be a scalar scaling factor.}

\item{scale}{Logical indicating whether the design matrix X be scaled. See details.}

\item{returnMSE}{Logical indicating whether mse object should be returned.}

\item{postsamp}{List containing posterior sample (from \code{samplePosterior}). If
missing, then a posterior sample is drawn.  Currently checks on the provided
\code{postsamp} are limited, so use with caution.  Designed to facilitate
simulations or other scenarios where it may be pre-computed.}

\item{returnPS}{logical indicating whether or not the full posterior sample should
be included in output.}

\item{nPost}{Size of posterior sample to compute}

\item{se.version}{String indicating which version of standard errors to use. See \code{\link{vcovfestRidge}}.}

\item{...}{Other arguments passed to \code{samplePosterior}}

\item{XtXlamIinv}{Optional explicit value of \code{(XtX + diag(lambda*penalize))^(-1)}. Useful
for simulations to save computation.}
}
\description{
Computes a ridge or LASSO estimate for a given regression problem, with penalty parameter chosen to minimize bias and variance.
}
\details{
The value of the ridge or LASSO penalty is selected by minimizing the 
	posterior expectation of the loss function, which is chosen by the argument
	\code{loss}. Possible options are \code{fMBV}, which uses the loss function
	\eqn{fMBV = max(Bias(\beta)^2, Var(\beta))} and \code{fMSE}, which uses the loss function
	\eqn{fMSE = Bias(\beta)^2 +  Var(\beta)}. 

	To balance the influence of covariates, it is recommended
	that the design matrix be standardized.  This can be done by
	the user or via the argument \code{scale}.  If \code{scale=TRUE},
	then coefficient and standard error estimates are back-transformed.

	Use the \code{XtXlamIinv} argument with caution. No checks are done on the provided
	value. Note that \code{lseq} is re-ordered to be decreasing, and provided values
	of \code{XtXlamIinv} must account for this.
}
\seealso{
\code{\link{mseRidge},\link{vcovfestRidge}, \link{simLASSO}, \link{check_CIbound}}
}
