% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esIdentical.R
\name{esIdentical}
\alias{esIdentical}
\title{esIdentical}
\usage{
esIdentical(esDf, RELEVANTVN_ES = NULL)
}
\arguments{
\item{esDf}{a data.frame. A single ESM dataset. It must contain the 2 columns that hold the date-time object for when an ESM questionnaire was started and finished, respectively.}

\item{RELEVANTVN_ES}{a list. This list is generated by function \code{\link{setES}} and it is extended once either by function \code{\link{genDateTime}} or by function \code{\link{splitDateTime}}.}
}
\value{
\code{esDf} with the additional column IDENT denoting an ESM questionnaire to be unique (= 0) or to be duplicated (= 1).
}
\description{
esIdentical checks whether there are fully identical lines of data in the ESM dataset.
}
\details{
At least 2 ESM questionnaires must be 100 percent identical in order to be registered as duplicates.
}
\examples{
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
# Prerequisites in order to execute esIdentical. Start --------------
# Use example list delivered with the package
RELEVANTVN_ES <- RELEVANTVN_ESext
# esAssigned is a list of datasets, delivered with the package. It is
# the result of the assignment of the ESM questionnaires to ALL 8
# participants in the reference dataset.
noEndDf <- missingEndDateTime(esAssigned[["ES"]], RELEVANTVN_ES)
# Prerequisites in order to execute esIdentical. End ----------------
# -------------------------------------------------------
# Run function 19 of 29; see esmprep functions' hierarchy.
# -------------------------------------------------------
# noEndDf is the result of function 'noEndDateTime'.
identDf <- esIdentical(noEndDf, RELEVANTVN_ES)
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
}
\seealso{
Exemplary code (fully executable) in the documentation of \code{\link{esmprep}} (function 19 of 29).
}
