% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genKey.R
\name{genKey}
\alias{genKey}
\title{genKey}
\usage{
genKey(dfList)
}
\arguments{
\item{dfList}{a list. Each element of the list must be a data.frame. Each data.frame is a separate raw ESM dataset/an ESM questionnaire version. If there is just one ESM version the list therefore contains one data.frame.}
}
\value{
\code{esDf} with the additional column KEY, i.e. a unique integer for each data row.
}
\description{
genKey generates a unique number for each ESM questionnaire.
}
\details{
The unique number for each ESM questionnaire can be seen as an identifier prior to the assignment of the participants who filled out the questionnaires. Such an identifier is valuable in controlling a large amount of rows of data.
}
\examples{
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
# Prerequisites in order to execute genKey. Start -------------------
relEs <- relevantESVN(svyName="survey_name", IMEI="IMEI",
STARTDATE="start_date", STARTTIME="start_time",
ENDDATE="end_date", ENDTIME="end_time")
imeiNumbers <- as.character(referenceDf$imei)
surveyNames <- c("morningTestGroup", "dayTestGroup", "eveningTestGroup",
"morningControlGroup", "dayControlGroup", "eveningControlGroup")
RELEVANT_ES <- setES(4, imeiNumbers, surveyNames, relEs)
RELEVANTVN_ES <- RELEVANT_ES[["RELEVANTVN_ES"]]
esLs <- esList(list(morningControl, dayControl, eveningControl,
morningTest, dayTest, eveningTest), RELEVANTVN_ES)
# Prerequisites in order to execute genKey. End ---------------------
# ------------------------------------------------------
# Run function 6 of 29; see esmprep functions' hierarchy.
# ------------------------------------------------------
# esLs is the result of function 'esList'.
keyLs <- genKey(esLs)
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
}
\seealso{
Exemplary code (fully executable) in the documentation of \code{\link{esmprep}} (function 6 of 29).
}
