% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rdcm_upgrade.R
\name{Rdcm.upgrade}
\alias{Rdcm.upgrade}
\title{Updating Rdcm files.}
\usage{
Rdcm.upgrade(Rdcm.files)
}
\arguments{
\item{Rdcm.files}{String vector, representing the list of the full names of the
Rdcm files, or its directories.}
}
\value{
Saves the updated Rdcm files. If the Rdcm files were generated from
the dicom files, the data is updated from the DICOM fields.
}
\description{
The \code{Rdcm.upgrade} function updates Rdcm files that were
created with a previous version.
}
\examples{
# First, save toy patient objects to a temporary file pat.dir for testing.
pat.dir <- file.path (tempdir(), "PM_Rdcm") 
dir.create (pat.dir, recursive = TRUE) 
patient <- toy.load.patient (modality = c("ct", "mr"), roi.name = "", 
                             dxyz = c (4, 4, 4))
save.to.Rdcm (patient$ct[[1]], dirname = pat.dir)
save.to.Rdcm (patient$mr[[1]], dirname = pat.dir)
save.T.MAT (patient$T.MAT, dirname = pat.dir)
# Rdcm files in pat.dir
list.files(pat.dir)

# test of Rdcm.upgrade

Rdcm.upgrade (pat.dir)
# or
Rdcm.upgrade (list.files (pat.dir, full.names = TRUE))

# Cleaning  temporary directories
unlink (pat.dir, recursive = TRUE)

}
