% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDataCatalog.R
\name{estat_getDataCatalog}
\alias{estat_getDataCatalog}
\title{getDataCatalog API}
\usage{
estat_getDataCatalog(
  appId,
  lang = c("J", "E"),
  .use_label = TRUE,
  surveyYears = NULL,
  openYears = NULL,
  statsField = NULL,
  statsCode = NULL,
  searchWord = NULL,
  dataType = NULL,
  catalogId = NULL,
  resourceId = NULL,
  startPosition = NULL,
  limit = NULL,
  updatedDate = NULL,
  ...
)
}
\arguments{
\item{appId}{Application ID.}

\item{lang}{Language of the data. \code{"J"}(Japanese) or \code{"E"}(English).}

\item{.use_label}{Whether to take the human-redable label value or the code value when
flattening a field containing both (default: \code{TRUE}).}

\item{surveyYears}{Year and month when the survey was conducted. The format is either
\code{"YYYY"}, \code{"YYYYMM"}, or \code{"YYYYMM-YYYYMM"}.}

\item{openYears}{Year and month when the survey result was opened. The format is the
same as \code{surveyYears}.}

\item{statsField}{Field of statistics. The format is either two digits(large classification)
or four digits (small classification). For the detail of the
classification, see \url{http://www.soumu.go.jp/toukei_toukatsu/index/seido/sangyo/26index.htm}.}

\item{statsCode}{Code assigned for each statistical agency and statistics. The format can
be five digits (agency), and eight digits (statistics). For the detail,
see \url{http://www.stat.go.jp/info/guide/public/code/code.htm}.}

\item{searchWord}{Keyword for searching. You can use \code{OR} and \code{AND} to combine conditions
(e.g.: \code{"apple AND orange"}).}

\item{dataType}{Type of data. \code{XLS}: Excel file, \code{CSV}: CSV file, \code{PDF}: PDF file, \code{DB}: Database.}

\item{catalogId}{Catalog ID.}

\item{resourceId}{Catalog resource ID.}

\item{startPosition}{Index of the first record to get.}

\item{limit}{Max number of records to get.}

\item{updatedDate}{Last updated date. The format is either \code{"YYYY"}, \code{"YYYYMM"}, or
\code{"YYYYMM-YYYYMM"}.}

\item{...}{Other parameters.}
}
\description{
Get information about the statistical dataset files and databases via e-Stat API.
}
\examples{
\dontrun{
estat_getDataCatalog(
  appId = "XXXX",
  searchWord = "CD",
  dataType = "XLS",
  limit = 3
)
}
}
\seealso{
\url{http://www.e-stat.go.jp/api/e-stat-manual3-0/#api_2_6}
\url{http://www.e-stat.go.jp/api/e-stat-manual3-0/#api_3_7}
}
