% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_Dirichlet.R
\name{Dir}
\alias{Dir}
\alias{d,Dir-method}
\alias{r,Dir-method}
\alias{mean,Dir-method}
\alias{mode,Dir-method}
\alias{var,Dir-method}
\alias{entro,Dir-method}
\alias{finf,Dir-method}
\alias{ll,matrix,numeric,Dir-method}
\alias{mle,matrix,Dir-method}
\alias{me,matrix,Dir-method}
\alias{same,matrix,Dir-method}
\alias{avar_mle,Dir-method}
\alias{avar_me,Dir-method}
\alias{avar_same,Dir-method}
\title{Dirichlet Distribution}
\usage{
Dir(alpha = c(1, 1))

\S4method{d}{Dir}(x)

\S4method{r}{Dir}(x)

\S4method{mean}{Dir}(x)

\S4method{mode}{Dir}(x)

\S4method{var}{Dir}(x)

\S4method{entro}{Dir}(x)

\S4method{finf}{Dir}(x)

\S4method{ll}{matrix,numeric,Dir}(x, prm, distr)

\S4method{mle}{matrix,Dir}(x, distr, par0 = "same", method = "L-BFGS-B", lower = 1e-05, upper = Inf)

\S4method{me}{matrix,Dir}(x, distr)

\S4method{same}{matrix,Dir}(x, distr)

\S4method{avar_mle}{Dir}(distr)

\S4method{avar_me}{Dir}(distr)

\S4method{avar_same}{Dir}(distr)
}
\arguments{
\item{alpha}{numeric. The distribution parameters.}

\item{x}{an object of class \code{Dir}. If the function also has a \code{distr}
argument, \code{x} is a numeric vector, a sample of observations.}

\item{prm}{numeric. A vector including the distribution parameters.}

\item{distr}{an object of class \code{Dir}.}

\item{par0, method, lower, upper}{arguments passed to optim.}
}
\value{
The dpqr family of functions return the evaluated density, cumulative
probability, quantile, and random sample, respectively.
The moments family of functions return the appropriate theoretical moment,
as calculated by the distribution true parameters.
The ll function returns the evaluated log-likelihood, given a sample and the
theoretical parameters.
The estim family of functions return the estimated parameters of the
distribution, given a sample.
The avar family of functions return the asymptotic variance or variance -
covariance matrix (if there are two or more parameters) of the corresponding
estimation method.
Calculus performed on Distribution objects returns a Distribution object of
the appropriate class and with the appropriate parameters.
}
\description{
Dirichlet Distribution
}
