% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_generics.R, R/02_Bern.R, R/02_Beta.R,
%   R/02_Binom.R, R/02_Cat.R, R/02_Dirichlet.R, R/02_Exp.R, R/02_Gam.R,
%   R/02_Geom.R, R/02_Laplace.R, R/02_Lnorm.R, R/02_Multinom.R, R/02_Nbinom.R,
%   R/02_Norm.R, R/02_Pois.R, R/02_Unif.R, R/02_Weib.R
\name{estim}
\alias{estim}
\alias{ebern}
\alias{ebeta}
\alias{ebinom}
\alias{ecat}
\alias{edirichlet}
\alias{eexp}
\alias{egamma}
\alias{egeom}
\alias{elaplace}
\alias{elnorm}
\alias{emultinom}
\alias{enbinom}
\alias{enorm}
\alias{epois}
\alias{eunif}
\alias{eweib}
\title{Parameter Estimation}
\usage{
estim(x, distr, type = "mle", ...)

ebern(x, type = "mle", ...)

ebeta(x, type = "mle", ...)

ebinom(x, type = "mle", ...)

ecat(x, type = "mle", ...)

edirichlet(x, type = "mle", ...)

eexp(x, type = "mle", ...)

egamma(x, type = "mle", ...)

egeom(x, type = "mle", ...)

elaplace(x, type = "mle", ...)

elnorm(x, type = "mle", ...)

emultinom(x, type = "mle", ...)

enbinom(x, type = "mle", ...)

enorm(x, type = "mle", ...)

epois(x, type = "mle", ...)

eunif(x, type = "mle", ...)

eweib(x, type = "mle", ...)
}
\arguments{
\item{x}{numeric. A sample under estimation.}

\item{distr}{A subclass of \code{Distribution}. The distribution family assumed.}

\item{type}{character, case ignored. The estimator type (mle, me, or same).}

\item{...}{extra arguments.}
}
\value{
numeric. The estimator produced by the sample.
}
\description{
Estimates the parameters of a random sample according to a
specified family of distributions.
}
\examples{
# -----------------------------------------------------
# Beta Distribution Example
# -----------------------------------------------------

# Simulation
set.seed(1)
shape1 <- 1
shape2 <- 2
D <- Beta(shape1, shape2)
x <- r(D)(100)

# Likelihood - The ll Functions

llbeta(x, shape1, shape2)
ll(x, c(shape1, shape2), D)
ll(x, c(shape1, shape2), "beta")

# Point Estimation - The e Functions

ebeta(x, type = "mle")
ebeta(x, type = "me")
ebeta(x, type = "same")

mle(x, D)
me(x, D)
same(x, D)

estim(x, D, type = "mle")

# Asymptotic Variance - The v Functions

vbeta(shape1, shape2, type = "mle")
vbeta(shape1, shape2, type = "me")
vbeta(shape1, shape2, type = "same")

avar_mle(D)
avar_me(D)
avar_same(D)

avar(D, type = "mle")
}
\references{
Ye, Z.-S. & Chen, N. (2017), Closed-form estimators for the gamma
distribution derived from likelihood equations, The American Statistician
71(2), 177–181.

Van der Vaart, A. W. (2000), Asymptotic statistics, Vol. 3,
Cambridge university press.

Tamae, H., Irie, K. & Kubokawa, T. (2020), A score-adjusted approach to
closed-form estimators for the gamma and beta distributions, Japanese Journal
of Statistics and Data Science 3, 543–561.

Mathal, A. & Moschopoulos, P. (1992), A form of multivariate gamma
distribution, Annals of the Institute of Statistical Mathematics 44, 97–106.

Oikonomidis, I. & Trevezas, S. (2023), Moment-Type Estimators for the
Dirichlet and the Multivariate Gamma Distributions, arXiv,
https://arxiv.org/abs/2311.15025
}
\seealso{
\link{mle}, \link{me}, \link{same}
}
