% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/energy.R
\name{energydist}
\alias{energydist}
\title{Naive computation for Energy Distance}
\usage{
energydist(
  X,
  Y,
  pval = TRUE,
  numperm = 200,
  seednum = 0,
  alternative = c("greater", "two.sided"),
  allowzeropval = FALSE
)
}
\arguments{
\item{X}{Matrix (or vector) of observations in first sample.}

\item{Y}{Matrix (or vector) of observations in second sample.}

\item{pval}{Boolean for whether to compute p-value or not.}

\item{numperm}{Number of permutations. Default is \code{200}.}

\item{seednum}{Seed number for generating permutations. Default is \code{0},
which means seed is set randomly. For values larger than
\code{0}, results will be reproducible.}

\item{alternative}{A character string specifying the alternative hypothesis,
which must be either \code{"greater"} (default) or
\code{"two.sided"}. In Gretton et al., the
MMD test statistic is specified so that if it is
significantly larger than zero, then the null hypothesis
that the two samples come from the same distribution
should be rejected. For this reason, \code{"greater"}
is recommended. The test will still work
in many cases with \code{"two.sided"} specified, but this
could lead to problems in certain cases.}

\item{allowzeropval}{A boolean, specifying whether we will allow zero
p-values or not. Default is \code{FALSE}; then
a threshold of \code{0.5 / (numperm+1)} is used,
and if the computed p-value is less than this
threshold, it is then set to be this value.
this avoids the possibility of zero p-values.}
}
\value{
A list with the following elements:
\describe{
\item{\code{pval}}{The p-value of the test, if it is
computed (\code{pval=TRUE}). }
\item{\code{stat}}{The statistic of the test, which
is always computed. }
}
}
\description{
Computes energy distance, and possibly a p-value.
Suitable for multivariate data. Naive approach, quadratic in number
of observations.
}
\details{
First checks number of columns (dimension) are equal.
Suppose matrix \eqn{X} has \eqn{n} rows and \eqn{d} columns,
and matrix \eqn{Y} has \eqn{m} rows; checks that \eqn{Y}
has \eqn{d} columns (if not, then throws error).
Then flattens matrices to vectors (or, if \eqn{d=1}, they are
already vectors.
Then calls C++ method. If the first sample has \eqn{n}
\eqn{d}-dimensional samples and the second sample has
\eqn{m} \eqn{d}-dimensional samples, then the algorithm
computes the statistic in \eqn{O((n+m)^2)} time.

Random seed is set for \code{std::mt19937} and \code{std::shuffle} in C++.
}
\examples{

X <- matrix(c(1:12), ncol=2, byrow=TRUE)
Y <- matrix(c(13:20), ncol=2, byrow=TRUE)
energydistList <- energydist(X=X, Y=Y, pval=FALSE)

#computing p-value
energydistList <- energydist(X=X, Y=Y)
\donttest{
#computing p-value
#using 1000 permutations and seed 1 for reproducibility.
energydistList <- energydist(X=X, Y=Y, numperm=1000, seednum=1)
}

}
\references{
Baringhaus L. and Franz C. (2004) "On a new multivariate two-sample test."
Journal of multivariate analysis 88(1):190-206

Szekely G. J. and Rizzo M. L. (2004) "Testing for equal distributions in
high dimension." InterStat 5(16.10):1249-1272
}
