% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-game-evolution.R
\name{getGameEvolution}
\alias{getGameEvolution}
\title{Get game evolution}
\usage{
getGameEvolution(season_code, game_code)
}
\arguments{
\item{season_code}{One or more season codes as obtained from \code{\link[=getCompetitionHistory]{getCompetitionHistory()}}.\cr
Examples are \code{E2023} for Euroleague or \code{U2023} for Eurocup 2023.}

\item{game_code}{One or more game codes as obtained from \code{\link[=getCompetitionGames]{getCompetitionGames()}}.}
}
\value{
Returns a list of two elements for the chosen games and seasons
\itemize{
\item \strong{EvolutionSummary}. Overall information about minimum and maximum difference of scores
between teams
\item \strong{Evolution}. Minute by minute points of each team
}

Reference webpage: \href{https://www.euroleaguebasketball.net/euroleague/game-center/2023-24/crvena-zvezda-meridianbet-belgrade-ldlc-asvel-villeurbanne/E2023/1/#graphic-stats}{GraphicStats}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{

\dontrun{

getGameEvolution(season_code = c("E2023", "U2023"), game_code = 1)

}

}
