% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-player-advanced.R
\name{getPlayerAdvanced}
\alias{getPlayerAdvanced}
\title{Get player advanced statistics}
\usage{
getPlayerAdvanced(
  season_code,
  statistic_mode = c("perGame", "perMinute", "accumulated")
)
}
\arguments{
\item{season_code}{One or more season codes as obtained from \code{\link[=getCompetitionHistory]{getCompetitionHistory()}}.\cr
Examples are \code{E2023} for Euroleague or \code{U2023} for Eurocup 2023.}

\item{statistic_mode}{One or more aggregation modes of statistics.\cr
Admitted values are \code{perGame}, \code{perMinute} and \code{accumulated}.}
}
\value{
Returns a summary tibble of advanced players statistics for chosen seasons.

Glossary of columns:\tabular{lll}{
   \strong{Column name} \tab \strong{Column extended name} \tab \strong{Column description} \cr
   eFG\% \tab Effective field goal \% \tab Combined two- and three-point shooting effectiveness \cr
   TS\% \tab True shooting \% \tab Percentage of points vs. points attempted \cr
   OREB\% \tab Offensive rebound \% \tab Estimated \% of available offensive rebounds obtained while on court \cr
   DREB\% \tab Defensive rebound \% \tab Estimated \% of available defensive rebounds obtained while on court \cr
   REB\% \tab Rebound \% \tab Estimated \% of available rebounds obtained while on court \cr
   AST/TO \tab Assist to turnover ratio \tab Ratio of assists made to turnovers committed \cr
   AST-R \tab Assist ratio \tab Estimated \% of assists per player's offensive possessions \cr
   TO-R \tab Turnover ratio \tab Estimated \% of turnovers per player's offensive possessions \cr
   2PTA-R \tab Two-point attempts ratio \tab Estimated \% of two-point attempts per player's offensive possessions \cr
   3PTA-R \tab Three-point attempts ratio \tab Estimated \% of three-point attempts per player's offensive possessions \cr
   FT-RT \tab Free Throw rate \tab Measure of free throw attempts vs. field goal attempts \cr
}


Reference webpage: \href{https://www.euroleaguebasketball.net/euroleague/stats/expanded/?size=1000&viewType=advanced&seasonCode=E2023&statisticMode=perGame&seasonMode=Single&sortDirection=descending&statistic=blocksFavour}{Stats}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{

\dontrun{

getPlayerAdvanced(season_code = "E2023", statistic_mode = "perGame")

}

}
