% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cut_to_classes.R
\name{cut_to_classes}
\alias{cut_to_classes}
\title{Cuts the Values Column into Classes and Polishes the Labels}
\usage{
cut_to_classes(
  x,
  n = 5,
  style = "equal",
  manual = FALSE,
  manual_breaks = NULL,
  decimals = 0,
  nodata_label = "No data"
)
}
\arguments{
\item{x}{A numeric vector, eg. \code{values} variable in data returned by
\code{\link[=get_eurostat]{get_eurostat()}}.}

\item{n}{A numeric. number of classes/categories}

\item{style}{chosen style: one of "fixed", "sd", "equal", "pretty", "quantile", "kmeans", "hclust", "bclust", "fisher", "jenks", "dpih", "headtails", "maximum", or "box"}

\item{manual}{Logical. If manual breaks are being used}

\item{manual_breaks}{Numeric vector with manual threshold values}

\item{decimals}{Number of decimals to include with labels}

\item{nodata_label}{String. Text label for NA category.}
}
\value{
a factor.
}
\description{
Categorises a numeric vector into automatic or manually defined
categories and polishes the labels ready for used in mapping with \code{ggplot2}.
}
\examples{
\dontshow{if (check_access_to_data()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# lp <- get_eurostat("nama_aux_lp")
lp <- get_eurostat("nama_10_lp_ulc")
lp$class <- cut_to_classes(lp$values, n = 5, style = "equal", decimals = 1)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[classInt:classIntervals]{classInt::classIntervals()}}

Other helpers: 
\code{\link{dic_order}()},
\code{\link{eurotime2date}()},
\code{\link{eurotime2num}()},
\code{\link{harmonize_country_code}()},
\code{\link{label_eurostat}()}
}
\author{
Markus Kainu \href{mailto:markuskainu@gmail.com}{markuskainu@gmail.com}
}
\concept{helpers}
