% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_eurostat_toc.R
\name{toc_determine_hierarchy}
\alias{toc_determine_hierarchy}
\title{Determine level in hierarchy}
\usage{
toc_determine_hierarchy(input_string)
}
\arguments{
\item{input_string}{A string containing Eurostat TOC titles}
}
\value{
Numeric
}
\description{
Divides the number of spaces before alphanumeric characters
with 4 and uses the result to determine hierarchy. Top level is 0.
}
\details{
Used in toc_determine_hierarchy function to determine hierarchy.
Hierarchy is defined in Eurostat .txt format TOC files by the number of
white space characters at intervals of four. For example,
"    Foo" (4 white space characters) is one level higher than
"        Bar" (8 white space characters).
"Database by themes" (0 white space characters before the first
alphanumeric character) is highest in the hierarchy.

The function will return a warning if the input has white space in anything
else than as increments of 4. 0, 4, 8... are acceptable but 3, 6, 10...
are not.
}
\examples{
strings <- c("        abc", "    cdf", "no_spaces")
eurostat:::toc_determine_hierarchy(strings)

}
\seealso{
\code{\link[=get_eurostat_toc]{get_eurostat_toc()}} \code{\link[=toc_count_children]{toc_count_children()}} \code{\link[=toc_determine_hierarchy]{toc_determine_hierarchy()}}
\code{\link[=toc_list_children]{toc_list_children()}} \code{\link[=toc_count_whitespace]{toc_count_whitespace()}}
}
\author{
Pyry Kantanen
}
\keyword{internal}
