% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_logic.R
\name{combine_logic}
\alias{combine_logic}
\title{combine_logic: Combine multiple logical vectors with a logical operator}
\usage{
combine_logic(..., op = "&", na.rm = FALSE)
}
\arguments{
\item{...}{Logical vectors to combine.}

\item{op}{Operator to apply: \code{"&"} (default) or \code{"|"}.}

\item{na.rm}{Logical. If TRUE, treats NA values as TRUE (default is FALSE).}
}
\value{
A single logical vector of the same length as inputs.
}
\description{
A utility function to combine two or more logical vectors using
logical AND (\code{&}) or OR (\code{|}) operations. Supports NA handling and
checks for consistent vector lengths.
}
\examples{
x <- 1:5
combine_logic(x > 2, x \%\% 2 == 1)            # AND by default
combine_logic(x > 2, x \%\% 2 == 1, op = "|")  # OR logic
combine_logic(c(TRUE, NA), c(TRUE, TRUE), na.rm = TRUE)
}
