% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_mirror.R
\name{set_mirror}
\alias{set_mirror}
\title{Set CRAN/Bioconductor Mirrors}
\usage{
set_mirror(repo = c("all", "cran", "bioc"), mirror = "tuna")
}
\arguments{
\item{repo}{Character. Repository type: "cran", "bioc", or "all" (default: "all").}

\item{mirror}{Character. Predefined mirror name (default: "tuna").}
}
\value{
Previous mirror settings (invisibly)
}
\description{
Switch CRAN and/or Bioconductor mirrors for faster package installation.
}
\examples{
\dontrun{
# Set all mirrors to tuna (default):
set_mirror()

# Set only CRAN mirror:
set_mirror("cran", "westlake")

# Set only Bioconductor mirror:
set_mirror("bioc", "ustc")
}

\donttest{
# Quick demo - view current mirror settings:
getOption("repos")
getOption("BioC_mirror")
}
}
