% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turc.R
\name{turc}
\alias{turc}
\alias{turc,missing,missing,missing-method}
\alias{turc,Raster,Raster,Raster-method}
\alias{turc,character,character,character-method}
\title{Calculate Potential Evapotranspiration (PET) using the Turc Method}
\usage{
turc(tavg, rs, rh, x = NULL)

\S4method{turc}{missing,missing,missing}(x)

\S4method{turc}{Raster,Raster,Raster}(tavg, rs, rh, x = NULL)

\S4method{turc}{character,character,character}(tavg, rs, rh, x = NULL)
}
\arguments{
\item{tavg}{Raster* object or file path; average temperature (°C)}

\item{rs}{Raster* object or file path; shortwave radiation (MJ m-2 day-1)}

\item{rh}{Raster* object or file path; relative humidity (percent)}

\item{x}{A `data.table` with columns: "lon", "lat", "date", "tavg", "rs", and "rh"}
}
\value{
RasterBrick or data.table of PET values (mm/day)
}
\description{
The function \code{turc} Computes PET using the Turc formula.
}
\details{
For Raster inputs, provide raster objects or file paths for `tavg`, `rs`, 
and `rh`. For data.table input, provide a single `data.table` with columns: "lon", "lat", "date", 
"tavg", "rs", and "rh".
}
\keyword{internal}
