% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudo-modules.R
\name{pseudo_independent}
\alias{pseudo_independent}
\title{Compute pseudo observations under independent censoring}
\usage{
pseudo_independent(
  formula,
  time,
  cause = 1,
  data,
  type = c("cuminc", "survival", "rmean"),
  formula.censoring = NULL,
  ipcw.method = NULL
)
}
\arguments{
\item{formula}{A formula specifying the model. The left hand side must be a
\link[survival]{Surv} object specifying a right censored survival or
competing risks outcome. The status indicator, normally 0=alive, 1=dead.
Other choices are TRUE/FALSE (TRUE = death) or 1/2 (2=death). For competing
risks, the event variable will be a factor, whose first level is treated as
censoring. The right hand side is the usual linear combination of
covariates.}

\item{time}{Numeric constant specifying the time at which the cumulative
incidence or survival probability effect estimates are desired.}

\item{cause}{Numeric or character constant specifying the cause indicator of
interest.}

\item{data}{Data frame in which all variables of formula can be interpreted.}

\item{type}{One of "survival", "cuminc", or "rmean"}

\item{formula.censoring}{Not used with this method, see
\link{pseudo_stratified}, \link{pseudo_aareg} or \link{pseudo_coxph}}

\item{ipcw.method}{Not used with this method}
}
\value{
A vector of jackknife pseudo observations
}
\description{
Assuming completely independent censoring, i.e., censoring does not depend on
the survival time nor any covariates in the model, the pseudo observations
are calculated with the standard jackknife approach
}
\examples{
POi <- pseudo_independent(Surv(time, status) ~ 1, 1500, cause = 1, data = colon, type = "survival")
mean(POi)

}
