% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudo-modules.R
\name{pseudo_infjack}
\alias{pseudo_infjack}
\title{Compute infinitesimal jackknife pseudo observations}
\usage{
pseudo_infjack(
  formula,
  time,
  cause = 1,
  data,
  type = c("cuminc", "survival", "rmean"),
  formula.censoring = NULL,
  ipcw.method = NULL
)
}
\arguments{
\item{formula}{A formula specifying the outcome model. The left hand side must be a
\link[survival]{Surv} object specifying a right censored survival,
competing risks, counting process, or multistate outcome. The status
indicator, normally 0=alive, 1=dead.
Other choices are TRUE/FALSE (TRUE = death) or 1/2 (2=death). For competing
risks and multi state models, the event variable will be a factor,
whose first level is treated as
censoring. The right hand side is the usual linear combination of
covariates.}

\item{time}{Numeric constant specifying the time at which the cumulative
incidence or survival probability effect estimates are desired.}

\item{cause}{Numeric or character constant specifying the cause indicator of
interest.}

\item{data}{Data frame in which all variables of formula can be interpreted.}

\item{type}{One of "survival", "cuminc", or "rmean"}

\item{formula.censoring}{A optional right-sided formula specifying which variables to
stratify on. All variables in this formula must be categorical.}

\item{ipcw.method}{Not used with this method}
}
\value{
A vector of pseudo observations
}
\description{
Assuming that the censoring depends on covariates with a finite set of levels,
the pseudo observations are calculated with the infinitesimal jackknife approach
stratified on those covariates. If no covariates are specified in the censoring model,
then the pseudo observations are calculated under the completely independent censoring
assumption. This function allows survival objects with entry and exit times, thus
multi-state models, recurrent events, and delayed entry/left truncation. With
delayed entry, the pseudo observation approach theoretically works under the assumption
that the entry time is independent of covariates.
}
\examples{
POi <- pseudo_infjack(Surv(time, status) ~ 1, 1500, cause = 1,
  data = colon, type = "survival", formula.censoring = ~ sex)

mean(POi)

}
\seealso{
\link[survival]{survfit}
}
