% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evolution.R
\name{send_media}
\alias{send_media}
\title{Send media (image, video, document) - robust for base64}
\usage{
send_media(
  client,
  number,
  mediatype,
  mimetype,
  caption = NULL,
  media,
  file_name,
  delay = NULL,
  link_preview = NULL,
  verbose = FALSE
)
}
\arguments{
\item{client}{An \code{\link[=evo_client]{evo_client()}} object.}

\item{number}{Character. Recipient in E.164 format (e.g., \code{"+5581999..."}).}

\item{mediatype}{One of "image", "video", "document".}

\item{mimetype}{e.g., "image/png", "video/mp4", "application/pdf".}

\item{caption}{Caption text (optional).}

\item{media}{Can be: (a) HTTP/HTTPS URL; (b) raw base64 (no prefix); (c) base64 in the format data:*;base64,<…>; (d) local file path.}

\item{file_name}{Suggested filename (consistent with the mimetype).}

\item{delay}{Integer (ms). Optional presence delay before sending.}

\item{link_preview}{Logical. Enable URL link preview.}

\item{verbose}{Detailed log output (cli + req_verbose()).}
}
\value{
A named list parsed from the Evolution API JSON response.
The list typically contains message metadata (IDs, timestamps, queue info),
and any additional fields defined by the API for media messages.
The HTTP status code is stored in \code{attr(result, "http_status")}.
This return value represents the server acknowledgement of the media upload/send.
}
\description{
Send media (image, video, document) - robust for base64
}
