% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate_gls.R
\name{rate_gls_sim}
\alias{rate_gls_sim}
\title{Simulate responses from \code{\link{rate_gls}} fit}
\usage{
rate_gls_sim(object, nsim = 10)
}
\arguments{
\item{object}{The fitted object from \code{\link{rate_gls}}}

\item{nsim}{The number of simulations.}
}
\value{
An object of \code{class} \code{'simulate_rate'}, which is a list
  with the following components: \tabular{llllll}{ \code{tips}
  \tab\tab\tab\tab A data frame of x and y values for the tips. \cr
  \code{percent_negative_roots} \tab\tab\tab\tab The percent of iterations
  with negative roots in the rates of y (not given for model =
  'recent_evol'). \cr \code{compl_dynamics}  \tab\tab\tab\tab A list with the
  output of the complete dynamics (not given for model = 'recent_evol'). }
}
\description{
\code{rate_gls_sim} responses from the models defined by an object of class
\code{'rate_gls'}.
}
\details{
\code{rate_gls_sim} simply passes the estimates in an object of
  class \code{'rate_gls'} to the function \code{\link{simulate_rate}} for
  simulating responses of the evolutionary process. It is mainly intended for
  internal use in \code{\link{rate_gls_boot}}.
}
\examples{
# See the vignette 'Analyzing rates of evolution'.
}
\author{
Geir H. Bolstad
}
