% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPaintedWhales.R
\name{plotPaintedWhales}
\alias{plotPaintedWhales}
\title{Plotting the whale phylogeny and coloring its clades}
\usage{
plotPaintedWhales(
  show.legend = TRUE,
  direction = "rightwards",
  knitr = FALSE,
  ...
)
}
\arguments{
\item{show.legend}{Logical indicating if clade legend should be shown.}

\item{direction}{Phylogeny plotting direction. Should be set to "rightwards"}

\item{knitr}{Logical indicating if plot is intended to show up in RMarkdown files made by the \code{Knitr} R package.
(the default) or "leftwards".}

\item{...}{other arguments to be passed to \code{phytools::plotSimmap}}
}
\value{
The whale phylogeny, with branch lengths being colored by a major
whale taxonomic group.
}
\description{
\code{plotPaintedWhales} plots the phylogeny from Steeman et al (2011), coloring the Dolphins (Delphinidae), porpoises (Phocoenidae), the Mysticetes, the baleen whales (Balaenopteridae), and the Beaked whales (Ziphiidae).
}
\examples{
plotPaintedWhales(knitr = TRUE)

}
\references{
Steeman, M. E., Hebsgaard, M. B., Fordyce, R. E., Ho, S. Y., Rabosky, D. L., Nielsen, R., ... & Willerslev, E. (2009). Radiation of extant cetaceans driven by restructuring of the oceans. Systematic biology, 58(6), 573-585.
}
\seealso{
help page from \code{phytools::plotSimmap}
}
\author{
Matheus Januario, Jennifer Auler
}
