% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotProteinSeq.R
\name{plotProteinSeq}
\alias{plotProteinSeq}
\title{Plot protein sequence(s)}
\usage{
plotProteinSeq(x, taxon.to.plot, knitr = FALSE)
}
\arguments{
\item{x}{A "ProteinSeq" object containing proteins from \code{taxon1}
and \code{taxon2}.}

\item{taxon.to.plot}{A character vector providing the common name of the species that will be plotted. Must be a name present in \code{x}.}

\item{knitr}{Logical indicating if plot is intended to show up in RMarkdown files made by the \code{Knitr} R package.}
}
\value{
A draw of the protein sequence(s) provided. Colors refer to
specific amino acids ("R", "W", "I", "F", "S", "T", "N", "H", "K", "D", "G", "L", "Y", "V", "M", "A", "E", "P", "Q", "C")", "gaps/space in the sequence ("-"), ambiguous amino acid ("B" - often representing either asparagine ("N") or aspartic acid ("D")), or another marker for  ambiguous amino acid ("X").
}
\description{
\code{plotProteinSeq} draws the sequences of proteins within the same "ProteinSeq" object. In this format, more similar sequences will have
similar banding patterns.
}
\examples{
data(cytOxidase)
plotProteinSeq(cytOxidase, c("human", "chimpanzee", "cnidaria"), knitr = TRUE)

}
\author{
Matheus Januario, Jennifer Auler
}
