% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_bootstrap.R
\name{reg_bootstrap}
\alias{reg_bootstrap}
\title{Regular Bootstrap with Summary Statistics}
\usage{
reg_bootstrap(
  data,
  n_bootstraps = 10000,
  anon = function(x) (mean(x)),
  lb = 0.025,
  ub = 0.975,
  density_args
)
}
\arguments{
\item{data}{A numeric vector of data points.}

\item{n_bootstraps}{An integer indicating the number of bootstrap samples to
generate. Default is 10000.}

\item{anon}{A function to compute the sample statistic for each bootstrap
sample. Default is the mean function.}

\item{lb}{Lower bound for the confidence interval. Default is 0.025.}

\item{ub}{Upper bound for the confidence interval. Default is 0.975.}

\item{density_args}{Additional arguments to be passed to \code{\link[stats]{density}} function.}
}
\value{
A list with two elements: \itemize{
\item dens: a density estimate of the bootstrap sample statistics,
\item stats: a list of summary statistics including number of resamples, mode,
median, mean, standard deviation, lower confidence interval (lCI), and upper
confidence interval (uCI).}
}
\description{
Performs a regular bootstrap to generate a distribution of sample
statistics and computes a set of summary statistics: mode, median, mean,
standard deviation, and lower and upper confidence intervals.
}
\examples{
set.seed(123)
data <- rnorm(5)
result <- reg_bootstrap(data)
result$stats
}
\seealso{
\code{\link{plot.regboot}}, \code{\link{summary.regboot}}
}
