% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/breaks.R
\name{breaks}
\alias{breaks}
\alias{add_breaks}
\alias{dbreaks}
\title{Generate Break Points for Equidistant or Quantile Bins}
\usage{
breaks(x, width = NULL, probs = NULL)

add_breaks(x, width = NULL, probs = NULL)

dbreaks(x, width = NULL, probs = NULL)
}
\arguments{
\item{x}{numeric vector: the data to compute breaks for.}

\item{width}{numeric, optional: desired bin width (default: \code{NULL}, auto-calculated).}

\item{probs}{numeric, optional: number of quantiles (single integer) or
vector of probabilities in \eqn{[0, 1]} for non-equidistant bins (default: \code{NULL}).}
}
\value{
A numeric vector containing the break points.
}
\description{
Creates a numeric vector of break points for the given data \code{x}.
The resulting breaks define bins that are either equidistant (fixed width)
or non-equidistant (quantile-based). If \code{width} is not specified, it defaults
to \code{diff(pretty(x))[1]}. The \code{probs} argument can either be a single
integer, specifying the number of quantiles, or a numeric vector of probabilities
in the interval \eqn{[0, 1]}.
}
\details{
If \code{probs} is used, break points are rounded to the nearest multiple of \code{width}.
Duplicates are removed, and the range is extended if necessary to include the
full range of \code{x}.
}
\examples{
x <- rnorm(100, mean = 1.8, sd = 0.1)
breaks(x)                # equidistant bins
breaks(x, width = 0.1)   # custom width bins
breaks(x, width = 0.1, probs = 4)  # quantile-based bins
}
