% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperloop.R
\name{hyperloop}
\alias{hyperloop}
\alias{hloop}
\title{Hyperloop}
\usage{
hyperloop(FUN, ..., .simplify = FALSE)

hloop(FUN, ..., .simplify = FALSE)
}
\arguments{
\item{FUN}{function with named parameter(s)}

\item{...}{named parameters which contain lists with possible parameter values}

\item{.simplify}{logical: should the result be simplified to a data frame (if possible)? (default: \code{FALSE})}
}
\value{
A \code{hyperloop} object as a list.
}
\description{
Runs a function several times with all parameter combinations, and checks:
\itemize{
\item if an argument is not a list, then it will be converted to an one element list
\item if an error occurs then the result of \code{FUN} will not be stored
}
}
\examples{
x   <- rnorm(100)
trm <- hyperloop(mean, x=list(x), trim=as.list(seq(0, 0.5, by=0.05)))
# automatic conversion of x to list(x)
trm <- hyperloop(mean, x=x, trim=as.list(seq(0, 0.5, by=0.05))) 
unlist(trm)
}
