% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_choice.R
\name{to_choice}
\alias{to_choice}
\alias{choice_list}
\title{Questions and Solutions List Generation}
\usage{
to_choice(
  df,
  correct,
  shuffle = c(NA_integer_, NA_integer_),
  orderfun = order,
  ...
)

choice_list(
  df,
  correct,
  shuffle = c(NA_integer_, NA_integer_),
  orderfun = order,
  ...
)
}
\arguments{
\item{df}{vector or data frame: values, in a data frame each row holds one value}

\item{correct}{logical: answer is correct (\code{TRUE}) or not (\code{FALSE})}

\item{shuffle}{integer: the numbers of correct and wrong values to shuffle (default: \code{c(NA,NA)}). \code{NA} means no shuffling}

\item{orderfun}{function: ordering of the shuffled values (default: \code{order})}

\item{...}{further named parameters used in \code{shuffle}}
}
\value{
list with questions and solutions
}
\description{
Creates a list with the elements \code{questions} and \code{solutions} values. A value can be either an entry in a vector or
a row in a data frame. \code{correct} is a logical vector which contains \code{TRUE} if its value represents a correct answer
and \code{FALSE} if it represents a wrong answer. The values can be shuffled or ordered (default).

If \code{shuffle} is a integer of length 1 then one correct answer is chosen, and \code{shuffle} wrong answers are chosen.
If \code{shuffle} is a integer of length larger than 1, then \code{shuffle[1]} correct answers are chosen and \code{shuffle[2]} wrong answers are chosen.
If any \code{shuffle} entry is zero or negative, then no shuffling will be done.
If \code{order} is a function then it is expected that the function delivers an index for the reordering of the values.
Otherwise a \code{shuffle} for all values is applied.

The shuffling works in two steps:
\enumerate{
\item Sample within the correct and wrong value according to \code{shuffle}
\item Apply shuffling (\code{order=NULL}) or ordering (default: \code{order=order}) of all selected answers
}
}
\examples{
answer   <- runif(5)
correct  <- (1:5)==3 # Third answer is correct, the rest wrong
sc       <- to_choice(answer, correct)
str(sc)           # Answers are ordered by size
sc$questions <- c(format(sc$questions, nsmall=2), "No answer is correct") # Additional answer
sc$solutions <- c(sc$solutions, FALSE)                                    # TRUE or FALSE?
sc           <- to_choice(answer, correct, shuffle=2)
str(sc)      # One correct answer and two wrong answers selected
}
