% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expandFunctions.R
\name{eQuad}
\alias{eQuad}
\title{Multivariate second order polynomial expansion.}
\usage{
eQuad(X, FUN = `*`, ...)
}
\arguments{
\item{X}{vector or matrix.  If a vector, it will be converted to
a column matrix.  If it is desired that the squares
and products of a \emph{vector} are computed, pass rbind(X)
instead of X, and thereby pass a row matrix.}

\item{FUN}{Binary function which forms the products of the columns.
By default, this is `*`, but other \emph{commuting} operators
or kernels can be used if desired.}

\item{...}{Options for FUN.  Not needed if FUN doesn't have options.}
}
\value{
\eqn{[X,X^2,unique products of columns of X]}.  The unique
      products are in row major upper right triangular order.
      Thus, for X with columns 1:3, the order is
      \deqn{X[,1]^2, X[,2]^2, X[,3]^2,
      X[,1]*X[,2], X[,1]*X[,3], X[,2]*X[,3]}
}
\description{
Expand matrix columns into linear, square, and unique product columns.
}
\details{
Form a matrix with columns composed of  into linear, square, and
product columns:

\deqn{[X | FUN(X[,i], X[,j])]}

where \eqn{i, j} are the unique combinations of \eqn{i} and \eqn{j},
including \eqn{i=j}.

By default, the function used to form the squares and
products, FUN, is just conventional multiplication = `*`, but any
\emph{commuting} binary operator can be used.

This particular expansion is often applied in

\itemize{
  \item{General Method of Data Handling (GMDH).}
  \item{Nonlinear Slow Feature Analysis (SFA).  Performing
  a multivariate polynomial of second degree expansion
  in all the features, then
  performing \emph{linear} SFA on the resulting expanded
  feature matrix, is a very common approach, and in fact
  is the default method in \code{sfa2 \{rSFA\}}.}
}
}
\examples{
# # Examples
# eQuad(1:5)
# eQuad(matrix(1:12,ncol=3),FUN=`+`)
}
\seealso{
\code{\link[rSFA]{sfa2}}
}

