% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/follow_up.R
\name{valid_followup}
\alias{valid_followup}
\title{Check the data for a follow up experiment.}
\usage{
valid_followup(
  old_data = NULL,
  new_data = NULL,
  all_data = NULL,
  omit = NULL,
  column = "batch"
)
}
\arguments{
\item{old_data, new_data}{A data.frame with the old and new data respectively.}

\item{all_data}{A \code{data.frame} with all the data about the samples.
Each row is a sample.}

\item{omit}{Name of the columns of the \code{pheno} that will be omitted.}

\item{column}{The name of the column where the old data has the batch
information, or whether the data is new or not (\code{NA}) in the case of all_data.}
}
\value{
Called by its side effects of warnings, but returns a logical value
if there are some issues (\code{FALSE}) or not (\code{TRUE})
}
\description{
Sometimes some samples are collected and analyzed, later another batch of
samples is analyzed.
This function tries to detect if there are problems with the data or when
the data is combined in a single analysis.
To know specific problems with the data you need to use check_data()
}
\examples{
data(survey, package = "MASS")
survey1 <- survey[1:118, ]
survey2 <- survey[119:nrow(survey), ]
valid_followup(survey1, survey2)
survey$batch <- NA
survey$batch[1:118]  <- "old"
valid_followup(all_data = survey)
}
\seealso{
\code{\link[=check_data]{check_data()}}
}
