% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_benchmark_score.R
\name{compare_benchmark_score}
\alias{compare_benchmark_score}
\title{Compare Score with a Benchmark}
\usage{
compare_benchmark_score(
  data,
  benchmark,
  alpha,
  tail = "one",
  remove_missing = TRUE
)
}
\arguments{
\item{data}{a column or vector of scores}

\item{benchmark}{benchmark}

\item{alpha}{alpha}

\item{tail}{one-tailed or two-tailed test}

\item{remove_missing}{TRUE/FALSE remove missing values? (default is TRUE)}
}
\value{
lower_ci, upper_ci, t, probability
}
\description{
Compare Score with a Benchmark
}
\examples{
data <- 68 + 17 * scale(rnorm(20)) # 68 = mean, 17 = sd
compare_benchmark_score(data, benchmark = 60, alpha = 0.5)
}
