% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATOPsens.R
\name{ATOPsens}
\alias{ATOPsens}
\title{Sensitivity analysis for the ATOP when some of the Outcome Data are
Missing Under the Matched-Pairs Design}
\usage{
ATOPsens(Ya, Yb, Ra, Rb, Ta, Tb, gamma, l, u, alpha, rep)
}
\arguments{
\item{Ya}{A vector of the outcomes of the first unit in the matched pairs. The missing values for \code{Ya} should be coded
as \code{NA}.}

\item{Yb}{A vector of the outcomes of the second unit in the matched pairs. The missing values for \code{Yb} should be coded
as \code{NA}.}

\item{Ra}{A vector of the missing data indicators of the first unit in the matched pairs.}

\item{Rb}{A vector of the missing data indicators of the second unit in the matched pairs.}

\item{Ta}{A vector of the treatment conditions of the first unit in the matched pairs.}

\item{Tb}{A vector of the treatment conditions of the second unit in the matched pairs.}

\item{gamma}{The sensitivity parameter which charaterizes the degree of the within-pair similarity.}

\item{l}{The lower limit of the outcome.}

\item{u}{The upper limit of the outcome.}

\item{alpha}{A positive scalar that is less than or equal to 0.5. This will
determine the (1-\code{alpha}) level of confidence intervals. The default is
\code{0.05}.}

\item{rep}{The number of repetitions for bootstraping.}
}
\value{
A list of class \code{ATOPsens} which contains the following items:
\item{LB}{ The lower bound for the ATOP.  } \item{UB}{ The upper bound for the ATOP.   }
\item{LB.CI}{ The lower limit of the confidence interval for the ATOP.   }
\item{UB.CI}{ The upper limit of the confidence interval for the ATOP.    }
}
\description{
This function computes the bounds on the average treatment effect among always-observed pairs (ATOP)
 with pre-specified sensivity parameters when
some of the outcome data are missing. The sensivity parameter characterizes the degree of the within-pair similarity.
The confidence intervals for the
ATOP are also computed.
}
\details{
For the details of the method implemented by this function, see the
references.
}
\examples{
data(seguro)
attach(seguro)
ATOPobs(Ya,Yb,Ra,Rb,Ta,Tb,gamma=0.95,kappa1=1,kappa0=1,l=0,u=1,alpha=0.05,rep=100)
}
\references{
Kosuke Imai and Zhichao Jiang (2018).
\dQuote{A Sensitivity Analysis for Missing Outcomes Due to 
Truncation-by-Death under the Matched-Pairs Design}, \emph{Statistics in Medicine}.
}
\author{
Kosuke Imai, Department of Government and Department of Statistics, Harvard University
\email{imai@Harvard.Edu}, \url{https://imai.fas.harvard.edu};
Zhichao Jiang, Department of Politics, Princeton University
\email{zhichaoj@princeton.edu}.
}
\keyword{design}
\keyword{matched-pairs}
