% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SHELF_funcs.R
\name{cred_int}
\alias{cred_int}
\title{Credible interval for pooled distribution}
\usage{
cred_int(plt_obj, val = "linear pool", interval = c(0.025, 0.975))
}
\arguments{
\item{plt_obj}{A plot object from \code{plot_expert_opinion}.}

\item{val}{The name of the opinion for which the interval will be generated.}

\item{interval}{A vector of the upper and lower probabilities. Default is the standard 95\% interval}
}
\value{
Credible interval based on the pooled distribution
}
\description{
Returns the interval based on defined quantiles.
The approach used only provides an approximate (although quite accurate) integral.
}
\examples{
param_expert_example1 <- list()
param_expert_example1[[1]] <- data.frame(dist = c("norm","t"),
    wi = c(0.5,0.5), # Ensure Weights sum to 1
    param1 = c(0.1,0.12),
    param2 = c(0.005,0.005),
    param3 = c(NA,3))
  \donttest{
plot_opinion1<- plot_expert_opinion(param_expert_example1[[1]], 
              weights = param_expert_example1[[1]]$wi)
cred_int(plot_opinion1,val = "linear pool", interval = c(0.025, 0.975))
}

}
\keyword{Expert}
