% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fun_tabularExpSummary.R
\name{tabularExpSummary}
\alias{tabularExpSummary}
\title{Summarize the experiment with a table for given outputs}
\usage{
tabularExpSummary(exp, outputs, boldfaceColumns = "none", format = "f",
  digits = 4, tableSplit = 1, rowsAsMethod = TRUE)
}
\arguments{
\item{exp}{The ource experiment to generate the table from}

\item{outputs}{A given variable or list of them to be the target of the table}

\item{boldfaceColumns}{Indicate ("none","max" or "min") to highlight the
method optimizing the variables for each problem.}

\item{format}{Indicates the format of the numeric output using C formatting
styles. Defaults to 'f'}

\item{digits}{The number of decimal digits to include for the numeric output.}

\item{tableSplit}{Indicates the number of parititions of the table that
will be rendered. Usefull when the the table is excessivelly wide.}

\item{rowsAsMethod}{Display the methods as the rows of the table, indicate
FALSE for a transpose table.}
}
\value{
An extabular object
}
\description{
This function generates a table for the given outputs of the experiment,
comparing all methods for each one of the problems. In addition the function
can highlight the best results for each problem as well as display a range of
parameters for the posterior renderization.
}
\examples{
# This example plots the distribution of the trainingTime variable in the
# wekaExperiment problem.

# First we create the experiment from the problem.
experiment <- expCreate(wekaExperiment, name="test", parameter="fold")

# Next we must process it to have an unique parameter configuration:
# We select a value for the parameter featureSelection:
experiment <- expSubset(experiment, list(featureSelection = "yes"))
# Then we reduce the fold parameter:
experiment <- expReduce(experiment, "fold", mean)
# Finally we remove unary parameters by instantiation:
experiment <- expInstantiate(experiment, removeUnary=TRUE)

# Generate the default table:
tabularExpSummary(experiment, "accuracy")
}

