% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{amd3}
\alias{amd3}
\title{Ten year neovascular AMD survival data}
\format{
A data frame (tibble) with 6696 rows and 23 variables:
\describe{
\item{patID}{Anonymized patient identifier.}
\item{sex}{Sex of patient (m = male, f = female)}
\item{time}{time in days after date of first injection (0 = first injection or baseline)}
\item{eye}{Left or right eye of patient (r = right, l = left)}
\item{ethnicity}{Ethnicity of patient following the categories from the
UK ETHNIC CATEGORY CODE 2001. (asian = Asian or Asian British,
white = White, black = Black or Black British,
other_unknown = Other ethnic group or unknown)}
\item{fellow}{fellow eye requires anti-VEGF within observation period}
\item{ttofellow}{time between baseline and fellow eye involvement in months}
\item{drug_switch}{anti-VEGF drug agent is switched during observation period }
\item{ttodrugswitch}{time between baseline and date of drug switch in months}
\item{ltfu}{patient is lost to follow-up during observation period }
\item{ltfu_stable}{of those lost to follow-up, are they stable prior to this timepoint }
\item{ltfu_outcome}{reason for lost to follow-up (discharged, dna (did not attend last appointment), dead, transferred)}
\item{ttoltfu}{time between baseline and loss to follow-up in months}
\item{stable10y}{patient is stable at ten year timepoint }
\item{irf}{presence of intraretinal fluid at last visit }
\item{srf}{presence of subretinal fluid at last visit }
\item{disciform}{presence of disciform scar at last visit (0 = no, 1a = type 1a, 1b = type 1b)}
\item{ga}{presence of geographic atrophy at last visit  }
\item{ga_foveal}{presence of foveal geographic atrophy at last visit}
\item{ttoga}{time to geographic atrophy development in months}
\item{injgiven}{injection given (TRUE) or not given (FALSE)}
\item{va}{visual acuity in Early Treatment Diabetic Retinopathy Study letters}
\item{crt}{foveal thickness in microns}
}
}
\source{
\url{https://doi.org/10.5061/dryad.9cnp5hqfm}
}
\usage{
data("amd3")
}
\description{
Ten Year Survival Trends of Neovascular Age Related Macular Degeneration
at First Presentation
}
\section{Central retinal thickness (CRT)}{

There are double CRT measurements for 1011 time points. This is because the
data set curator provided both automatic measurement and manual measurement.
Unfortunately, based on the information in the raw data, it is not possible
to know which entry belongs to which. One possible way to adjust for this may
be to create an average for both measurements. For one way to do this, see
"Examples"
}

\section{Missing values}{

There are 1388 missing visual acuity entries and 858 missing central retinal
thickness entries.
}

\section{Study setting and design}{

Retrospective cohort study of treatment-naïve, first-affected eyes with
nAMD started on ranibizumab before January 1, 2009.
Approval was granted by the Institutional Review Board of the hospital
(ROAD17/031). The study complied with the Declaration of Helsinki
}

\section{Data source}{

All clinical information at Moorfields Eye Hospital is recorded within an
electronic medical record (EMR) application (OpenEyes Foundation, London, UK).
Information governance authorised Moorfields Eye Clinic 19/07/2018.
Age not provided as a continuous variable as in original analysis
to facilitate de-identification
}

\examples{
library(dplyr)
amd3 \%>\%
  group_by(patID, time) \%>\%
  mutate(crt_av = mean(crt, na.rm = TRUE)) \%>\%
  select(-crt) \%>\%
  distinct()
}
\seealso{
Scientific article to which this data set was supplement:
\url{https://doi.org/10.1136/bjophthalmol-2020-317161}
}
\keyword{datasets}
