% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pr_plot.R
\name{pr_plot}
\alias{pr_plot}
\title{pr_plot}
\usage{
pr_plot(
  data,
  fitted,
  actual,
  group = NULL,
  facet_x = NULL,
  facet_y = NULL,
  palette = ez_col,
  size_line = 1,
  size = 11,
  labs = "short",
  env = parent.frame()
)
}
\arguments{
\item{data}{A data.frame.}

\item{fitted}{Vector of fitted values}

\item{actual}{Vector of actual values}

\item{group}{A character value. Evaluates to a column.}

\item{facet_x}{A character value. Evaluates to a column.}

\item{facet_y}{A character. Evaluates to a column.}

\item{palette}{Colour function.}

\item{size_line}{width of line for \code{geom_line()}. Default is 1.}

\item{size}{theme size for \code{use_theme()}. Default is 14.}

\item{labs}{'short' or 'long'}

\item{env}{environment for evaluating expressions.}
}
\description{
precision-recall plot
}
\examples{
library(ggplot2)
n = 1000
df = data.frame(actual = sample(c(FALSE, TRUE), n, replace = TRUE),
                runif = runif(n))
df[["fitted"]] = runif(n) ^ ifelse(df[["actual"]] == 1, 0.5, 2)

density_plot(df, "fitted", "actual")

pr_plot(df, "fitted", "actual")
pr_plot(df, "runif", "actual", size_line = 0.5)

\donttest{
library(dplyr, warn.conflicts = FALSE)
pr_plot(df, "fitted", "actual", "sample(c(1, 2), n(), TRUE)")

pr_plot(df, "fitted", "actual",
        "sample(c(1, 2), n(), TRUE)",
        "sample(c(3, 4), n(), TRUE)")

pr_plot(df, "fitted", "actual",
        "sample(c(1, 2), n(), TRUE)",
        "sample(c(3, 4), n(), TRUE)",
        "sample(c(5, 6), n(), TRUE)")
}
}
