% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cidr.R
\name{cidr}
\alias{cidr}
\alias{ocidr}
\title{Compute (Overnight) Cumulative Intraday Returns}
\usage{
cidr(X)

ocidr(X)
}
\arguments{
\item{X}{A dfts object or data which can be automatically converted to that
format. See \code{\link[=dfts]{dfts()}}.}
}
\value{
A dfts object with CIDR or OCIDRs
}
\description{
Compute (Overnight) Cumulative Intraday Returns
}
\examples{
tmp <- dfts(SPYUS500$data[, 1:100],
  name = "SP500 100 Days",
  labels = SPYUS500$labels[1:100], fparam = SPYUS500$fparam
)
cidr(tmp)
tmp <- dfts(SPYUS500$data[, 1:100],
  name = "SP500 100 Days",
  labels = SPYUS500$labels[1:100], fparam = SPYUS500$fparam
)
ocidr(tmp)
}
\references{
Rice, G., Wirjanto, T., & Zhao, Y. (2023). Exploring volatility
of crude oil intraday return curves: A functional GARCH-X model. Journal of
Commodity Markets, 32, 100361-.
}
