
#' @title remove subject
#' @name remove_subject
#' @description
#' Removes a subject from a gallery.
#' @param subject_id The subject id for the subject to be removed.
#' @param gallery The name of the gallery in which the subject is enrolled.
#'
#' @return nothing.
#' @export
#'
#' @examples
#' \donttest{
#'
#' facerec_init()
#'
#' # enroll
#' finn_image <- 'https://upload.wikimedia.org/wikipedia/en/2/2a/Finn-Force_Awakens_%282015%29.png'
#' finn_enroll <- enroll(image = finn_image, subject_id = 'finn', gallery = 'starwars')
#'
#' # remove subject
#' remove_subject(subject_id = 'finn', gallery = 'starwars')
#' }
#'
#'
remove_subject <- function(subject_id, gallery) {

  url <- kairos_api(path = '/gallery/remove_subject')
  params <- list(subject_id = subject_id, gallery_name = gallery)
  resp <- POST(url, body = params, encode = 'json',
               add_headers(.headers = .facerec$init ))
  data <- fromJSON(content(resp, 'text'))

  if ('Errors' %in% names(data)) {
    message <- data$Errors[[2]]
    stop(message)
  }
  else {
    print(data$message)
  }
}

