% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmEsDecomp.R
\name{fmEsDecomp}
\alias{fmEsDecomp}
\alias{fmEsDecomp.ffm}
\title{Decompose ES into individual factor contributions}
\usage{
fmEsDecomp(object, ...)

\method{fmEsDecomp}{ffm}(
  object,
  factor.cov,
  p = 0.05,
  type = c("np", "normal"),
  use = "pairwise.complete.obs",
  ...
)
}
\arguments{
\item{object}{fit object of class \code{tsfm}, \code{sfm} or \code{ffm}.}

\item{...}{other optional arguments passed to \code{\link[stats]{quantile}}.}

\item{factor.cov}{optional user specified factor covariance matrix with 
named columns; defaults to the sample covariance matrix.}

\item{p}{tail probability for calculation. Default is 0.05.}

\item{type}{one of "np" (non-parametric) or "normal" for calculating VaR. 
Default is "np".}

\item{use}{method for computing covariances in the presence of missing 
values; one of "everything", "all.obs", "complete.obs", "na.or.complete", or 
"pairwise.complete.obs". Default is "pairwise.complete.obs".}
}
\value{
A list containing 
\item{ES.fm}{length-N vector of factor model ES of N-asset returns.}
\item{mES}{N x (K+1) matrix of marginal contributions to VaR.}
\item{cES}{N x (K+1) matrix of component contributions to VaR.}
\item{pcES}{N x (K+1) matrix of percentage component contributions to VaR.}
Where, \code{K} is the number of factors and N is the number of assets.
}
\description{
Compute the factor contributions to Expected Tail Loss or 
Expected Shortfall (ES) of assets' returns  based on Euler's theorem, given 
the fitted factor model. The partial derivative of ES with respect to factor 
beta is computed as the expected factor return given fund return is less 
than or equal to its value-at-risk (VaR). Option to choose between 
non-parametric and Normal.
}
\details{
The factor model for an asset's return at time \code{t} has the 
form \cr \cr \code{R(t) = beta'f(t) + e(t) = beta.star'f.star(t)} \cr \cr 
where, \code{beta.star=(beta,sig.e)} and \code{f.star(t)=[f(t)',z(t)]'}. By 
Euler's theorem, the ES of the asset's return is given by:
\cr \cr \code{ES.fm = sum(cES_k) = sum(beta.star_k*mES_k)} \cr \cr
where, summation is across the \code{K} factors and the residual, 
\code{cES} and \code{mES} are the component and marginal 
contributions to \code{ES} respectively. The marginal contribution to ES is
defined as the expected value of \code{F.star}, conditional on the loss 
being less than or equal to \code{VaR.fm}. This is estimated as a sample 
average of the observations in that data window. 

Refer to Eric Zivot's slides (referenced) for formulas pertaining to the 
calculation of Normal ES (adapted from a portfolio context to factor models).
}
\references{
Epperlein, E., & Smillie, A. (2006). Portfolio risk analysis Cracking VAR 
with kernels. RISK-LONDON-RISK MAGAZINE LIMITED-, 19(8), 70.

Hallerback (2003). Decomposing Portfolio Value-at-Risk: A General Analysis. 
The Journal of Risk, 5(2), 1-18.

Meucci, A. (2007). Risk contributions from generic user-defined factors. 
RISK-LONDON-RISK MAGAZINE LIMITED-, 20(6), 84. 

Yamai, Y., & Yoshiba, T. (2002). Comparative analyses of expected shortfall 
and value-at-risk: their estimation error, decomposition, and optimization. 
Monetary and economic studies, 20(1), 87-121.
}
\seealso{
\code{\link{fitFfm}}
for the different factor model fitting functions.

\code{\link{fmSdDecomp}} for factor model SD decomposition.
\code{\link{fmVaRDecomp}} for factor model VaR decomposition.
}
\author{
Eric Zviot, Sangeetha Srinivasan and Yi-An Chen
}
