% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmSdDecomp.R
\name{fmSdDecomp}
\alias{fmSdDecomp}
\alias{fmSdDecomp.ffm}
\title{Decompose standard deviation into individual factor contributions}
\usage{
fmSdDecomp(object, factor.cov, ...)

\method{fmSdDecomp}{ffm}(object, factor.cov, ...)
}
\arguments{
\item{object}{fit object of class \code{tsfm} or \code{ffm}.}

\item{factor.cov}{optional user specified factor covariance matrix with 
named columns; defaults to the sample covariance matrix.}

\item{...}{optional arguments passed to \code{\link[stats]{cov}}.}
}
\value{
A list containing 
\item{Sd.fm}{length-N vector of factor model SDs of N-asset returns.}
\item{mSd}{N x (K+1) matrix of marginal contributions to SD.}
\item{cSd}{N x (K+1) matrix of component contributions to SD.}
\item{pcSd}{N x (K+1) matrix of percentage component contributions to SD.}
Where, \code{K} is the number of factors and N is the number of assets.
}
\description{
Compute the factor contributions to standard deviation (SD) of 
assets' returns based on Euler's theorem, given the fitted factor model.
}
\details{
The factor model for an asset's return at time \code{t} has the 
form \cr \cr \code{R(t) = beta'f(t) + e(t) = beta.star'f.star(t)} \cr \cr 
where, \code{beta.star=(beta,sig.e)} and \code{f.star(t)=[f(t)',z(t)]'}. 
\cr \cr By Euler's theorem, the standard deviation of the asset's return 
is given as: \cr \cr 
\code{Sd.fm = sum(cSd_k) = sum(beta.star_k*mSd_k)} \cr \cr 
where, summation is across the \code{K} factors and the residual, 
\code{cSd} and \code{mSd} are the component and marginal 
contributions to \code{SD} respectively. Computing \code{Sd.fm} and 
\code{mSd} is very straight forward. The formulas are given below and 
details are in the references. The covariance term is approximated by the 
sample covariance. \cr \cr
\code{Sd.fm = sqrt(beta.star''cov(F.star)beta.star)} \cr 
\code{mSd = cov(F.star)beta.star / Sd.fm}
}
\references{
Hallerback (2003). Decomposing Portfolio Value-at-Risk: A General Analysis. 
The Journal of Risk, 5(2), 1-18.

Meucci, A. (2007). Risk contributions from generic user-defined factors. 
RISK-LONDON-RISK MAGAZINE LIMITED-, 20(6), 84. 

Yamai, Y., & Yoshiba, T. (2002). Comparative analyses of expected shortfall 
and value-at-risk: their estimation error, decomposition, and optimization. 
Monetary and economic studies, 20(1), 87-121.
}
\seealso{
\code{\link{fitFfm}}
for the different factor model fitting functions.

\code{\link{fmCov}} for factor model covariance.
\code{\link{fmVaRDecomp}} for factor model VaR decomposition.
\code{\link{fmEsDecomp}} for factor model ES decomposition.
}
\author{
Eric Zivot, Yi-An Chen and Sangeetha Srinivasan
}
