% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/portSdDecomp.R
\name{portSdDecomp}
\alias{portSdDecomp}
\alias{portSdDecomp.ffm}
\title{Decompose portfolio standard deviation into individual factor contributions}
\usage{
portSdDecomp(object, ...)

\method{portSdDecomp}{ffm}(object, weights = NULL, factor.cov, ...)
}
\arguments{
\item{object}{fit object of class \code{tsfm}, or \code{ffm}.}

\item{...}{optional arguments passed to \code{\link[stats]{cov}}.}

\item{weights}{a vector of weights of the assets in the portfolio. Default is NULL, 
in which case an equal weights will be used.}

\item{factor.cov}{optional user specified factor covariance matrix with 
named columns; defaults to the sample covariance matrix.}
}
\value{
A list containing 
\item{portSd}{factor model Sd of portfolio return.}
\item{mSd}{length-(K + 1) vector of marginal contributions to Sd.}
\item{cSd}{length-(K + 1) vector of component contributions to Sd.}
\item{pcSd}{length-(K + 1) vector of percentage component contributions to Sd.}
Where, K is the number of factors.
}
\description{
Compute the factor contributions to standard deviation (Sd) of 
portfolio returns based on Euler's theorem, given the fitted factor model.
}
\details{
The factor model for a portfolio's return at time \code{t} has the 
form \cr \cr \code{R(t) = beta'f(t) + e(t) = beta.star'f.star(t)} \cr \cr 
where, \code{beta.star=(beta,sig.e)} and \code{f.star(t)=[f(t)',z(t)]'}. 
\cr \cr By Euler's theorem, the standard deviation of the portfolio's return 
is given as: \cr \cr 
\code{portSd = sum(cSd_k) = sum(beta.star_k*mSd_k)} \cr \cr 
where, summation is across the \code{K} factors and the residual, 
\code{cSd} and \code{mSd} are the component and marginal 
contributions to \code{Sd} respectively. Computing \code{portSd} and 
\code{mSd} is very straight forward. The formulas are given below and 
details are in the references. The covariance term is approximated by the 
sample covariance. \cr \cr
\code{portSd = sqrt(beta.star''cov(F.star)beta.star)} \cr 
\code{mSd = cov(F.star)beta.star / portSd}
}
\seealso{
\code{\link{fitFfm}}
for the different factor model fitting functions.

\code{\link{portVaRDecomp}} for portfolio factor model VaR decomposition.
\code{\link{portEsDecomp}} for portfolio factor model ES decomposition.
}
\author{
Douglas Martin, Lingjie Yi
}
