% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.tsfmUpDn.R
\name{plot.tsfmUpDn}
\alias{plot.tsfmUpDn}
\title{Plot actual against fitted values of up and down market time series factor model}
\usage{
\method{plot}{tsfmUpDn}(
  x,
  asset.name = NULL,
  SFM.line = FALSE,
  LSandRob = FALSE,
  line.color = c("blue", "purple"),
  line.type = c("dashed", "solid"),
  line.width = c(1, 2),
  sfm.line.type = "dashed",
  add.legend = TRUE,
  legend.loc = "topleft",
  legend.cex = 0.9,
  ...
)
}
\arguments{
\item{x}{an object of class \code{tsfmUpDn} produced by \code{fitTsfmUpDn}.}

\item{asset.name}{A vector of character to show single or multiple assets names. The defualt if 
\code{NULL}.}

\item{SFM.line}{A logic flag to add a fitted single factor model. The default is \code{FALSE}.}

\item{LSandRob}{A logic flag to add a comparison Up/Down factor model. If the original model
is \code{"LS"}, the comparison model is \code{"Robust"} and vice versa. The default is \code{FALSE}.
The default is \code{FALSE}.}

\item{line.color}{A vector of color codes of up/dn fitted line. The first element is for the object fitted
line and the second for the comparison fitted line. The default is \code{c("blue","purple")}.}

\item{line.type}{A vector of line types of up/dn fitted line. The first is for the object fitted
line and the second for the comparison fitted line. The default is \code{c("dashed","solid"}.}

\item{line.width}{A vector of line width of up/dn fitted line. The first element is for the object fitted
line and the second element for the comparison fitted line. The default is \code{c(1,2}.}

\item{sfm.line.type}{SFM line type. The default is \code{"dashed"}}

\item{add.legend}{A logic flag to add a legend. The default is \code{TRUE}.}

\item{legend.loc}{The default is \code{"topleft"}.}

\item{legend.cex}{\code{cex} of \code{legend}.}

\item{...}{Other arguments can be used in \code{plot}. Please refer to \code{plot}.}
}
\value{
\code{plot.tsfmUpDn} returns a plot for an object of class \code{tsfmUpDn}.
}
\description{
Generic \code{plot} method for object of class \code{tsfmUpDn}.
}
\details{
This method plots actual values against fitted value of up and down market time series
factor model. The dots are actual values and the dashed lines are fitted values. Users can 
choose to add a single market factor model and a robust up and down model for comaprsion. 

For other types of plots, use the list objects \code{Up} and \code{Dn} of class \code{tsfmUpDn}. 
The \code{plot.tsfm} can be applied.
}
\seealso{
\code{\link{fitTsfmUpDn}}
}
\author{
Yi-An Chen
}
