% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.tsfm.R
\name{print.tsfm}
\alias{print.tsfm}
\title{Prints a fitted time series factor model}
\usage{
\method{print}{tsfm}(x, digits = max(3, .Options$digits - 3), ...)
}
\arguments{
\item{x}{an object of class \code{tsfm} produced by \code{fitTsfm}.}

\item{digits}{an integer value, to indicate the required number of 
significant digits. Default is 3.}

\item{...}{optional arguments passed to the \code{print} method.}
}
\value{
\code{print.tsfm} prints a brief summary of an object of class 
\code{tsfm}.
}
\description{
S3 \code{print} method for object of class \code{tsfm}. Prints 
the call, factor model dimension, regression coefficients, r-squared and 
residual volatilities from the fitted object.
}
\examples{
data(managers, package = 'PerformanceAnalytics')
fit <- fitTsfm(asset.names=colnames(managers[,(1:6)]),
               factor.names=colnames(managers[,7:9]), 
               mkt.name="SP500.TR", data=managers)
print(fit)

}
\seealso{
\code{\link{fitTsfm}}, \code{\link{summary.tsfm}}
}
\author{
Yi-An Chen and Sangeetha Srinivasan
}
