% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_options.r
\name{faster}
\alias{faster}
\title{Set or get options shared across fasterRaster functions}
\usage{
faster(..., default = FALSE, restore = FALSE)
}
\arguments{
\item{...}{Either:
\itemize{
\item A character vector: Name(s) of option(s) to get values of;
\item An option and the value of the option using an \code{option = value} pattern; or
\item A names \code{list} with names that match the options you wish to change, and with values to assign to each option.
}

Options include:
\itemize{
\item \code{grassDir} (character): The folder in which \strong{GRASS} is installed on your computer. You must set this option to run most \strong{fasterRaster} functions. Depending on your operating system, your install directory will look something like this:
\itemize{
\item Windows: \code{"C:/Program Files/GRASS GIS 8.4"}
\item Mac OS: \code{"/Applications/GRASS-8.4.app/Contents/Resources"}
\item Linux: \code{"/usr/local/grass"}
}
\item \code{addonsDir} (character): Folder in which \strong{GRASS} addons are stored. If \code{NA} and \code{grassDir} is not \code{NA}, this will be assumed to be \code{file.path(grassDir, "addons")}. The default values is \code{NA}.
\item \code{cores} (integer/numeric integer): Number of processor cores to use on a task. The default is 2. Some \strong{GRASS} modules are parallelized.
\item \code{memory} (integer/numeric): The amount of memory to allocate to a task, in GB, for \strong{GRASS}. The default is 2048 MB (i.e., 2 GB). Some \strong{GRASS} modules can take advantage of more memory.
\item \code{useDataTable} (logical): If \code{FALSE} (default), functions that return tabular output produce \code{data.frame}s. If \code{TRUE}, output will be \code{data.table}s from the \strong{data.table} package. This can be much faster, but it might require you to know how to use \code{data.table}s if you want to manipulate them in \strong{R}. You can always convert them to \code{data.frame}s using \code{\link[base:as.data.frame]{base::as.data.frame()}}.
\item \code{verbose} (logical): If \code{TRUE}, show progress during function operations and other messages. Default is \code{FALSE}. This overrides the value of any \code{verbose} argument in a function.
\item \code{debug} (logical): If \code{TRUE}, show \strong{GRASS} messages and otherwise hidden slots in classes. This is mainly used for debugging, so most users will want to keep this at its default, \code{FALSE}.
\item \code{workDir} (character): The folder in which \strong{GRASS} rasters, vectors, and other objects are created and manipulated. By default, this is given by \code{\link[=tempdir]{tempdir()}}. Note that on some systems, changing the default folder to somewhere else can cause problems with \strong{fasterRaster} being able to find rasters in \strong{GRASS} that have been created.
}}

\item{default}{Logical: Return the default value(s) of the option(s). The default value of \code{default} is \code{FALSE}.}

\item{restore}{Logical: If \code{TRUE}, the all options will be reset to their default values. The default is \code{FALSE}.}
}
\value{
If options are changed, then a named list of option values \emph{before} they were changed is returned invisibly.

If option values are requested, a named list with option values is returned (not invisibly).
}
\description{
\code{faster()} either sets or gets options used across \strong{fasterRaster} functions. Its use can vary:
\itemize{
\item Get current values of a particular option: Use \code{faster("option_name")}. Values will remain unchanged.
\item Get current values of all options: Use \code{faster()} (no arguments). Values will remain unchanged.
\item Get default values of a particular option: Use \code{faster("option_name", default = TRUE)}. Values will remain unchanged.
\item Get default values of all options: Use \code{faster(default = TRUE)}. Values will remain unchanged.
\item Set values of particular options: Use the form \verb{faster(option 1 = value1, option2 = value2)}.
\item Set all options to their defaults: Use \code{faster(restore = TRUE)}.
}

You cannot simultaneously get and set options.

To run most \strong{fasterRaster} functions, you must set the \code{grassDir} option.
}
\examples{
if (grassStarted()) {

# See current values for options:
faster("grassDir")
faster("cores")
faster("memory")
faster("useDataTable")
faster() # all options

# See default values for options:
faster("cores", default = TRUE)
faster(default = TRUE) # all options

# Set options (change accordingly for your system!!!)
if (FALSE) {

   opts. <- faster() # remember starting values of options

   faster(grassDir = "C:/Program Files/GRASS GIS 8.4")
   faster(verbose = TRUE, memory = 1024, cores = 1)

   faster(c("grassDir", "verbose", "memory", "cores"))

   faster(opts.) # reset options to starting values

}

}
}
