% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/princomp.r
\name{pcs}
\alias{pcs}
\title{Retrieve a principal components model from a PCA GRaster}
\usage{
pcs(x)
}
\arguments{
\item{x}{A \code{GRaster} created by \code{\link[=princomp]{princomp()}}}
}
\value{
An object of class \code{prcomp}.
}
\description{
Retrieve a principal components model from a PCA GRaster
}
\examples{
if (grassStarted()) {

# Setup
library(terra)

# Climate raster:
madChelsa <- fastData("madChelsa")

# Convert a SpatRaster to a GRaster:
chelsa <- fast(madChelsa)

# Generate raster with layers representing principal component predictions:
pcRast <- princomp(chelsa, scale = TRUE)
plot(pcRast)

# Get information on the PCA:
prinComp <- pcs(pcRast)

prinComp
summary(prinComp)
plot(prinComp)

}
}
\seealso{
\code{\link[=princomp]{princomp()}}, \code{\link[terra:princomp]{terra::princomp()}}, tool \code{i.pca} in \strong{GRASS}
}
